<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json');

include("csism_db.php"); // your DB connection

$user_id = $_GET['user_id'] ?? 1;
$period = $_GET['period'] ?? 'this_week'; // 'this_week' or 'this_month'

// Calculate start and end date based on period
$today = date('Y-m-d');
if ($period == 'this_week') {
    $startDate = date('Y-m-d', strtotime('monday this week'));
    $endDate = date('Y-m-d', strtotime('sunday this week'));
} else { // this_month
    $startDate = date('Y-m-01');
    $endDate = date('Y-m-t');
}

// ---------------------
// Fetch attendance totals
// ---------------------
$stmt = $conn->prepare("
    SELECT 
        SUM(CASE WHEN status_type_id='1' THEN 1 ELSE 0 END) AS present_days,
        SUM(CASE WHEN status_type_id='2' THEN 1 ELSE 0 END) AS absent_days,
        COUNT(*) AS total_days
    FROM attendance
    WHERE user_id = ? AND shift_date BETWEEN ? AND ?
");
$stmt->bind_param('iss', $user_id, $startDate, $endDate);
$stmt->execute();
$result = $stmt->get_result();
$attendance = $result->fetch_assoc();

// Ensure no null values
$present_days = (int)($attendance['present_days'] ?? 0);
$absent_days = (int)($attendance['absent_days'] ?? 0);
$total_days = (int)($attendance['total_days'] ?? 0);

// ---------------------
// Fetch leave types with counts
// ---------------------
$stmt2 = $conn->prepare("
    SELECT 
        c.type, 
        c.color, 
        COUNT(a.status_type_id) AS count
    FROM c_status_types c
    LEFT JOIN attendance a 
        ON a.status_type_id = c.id 
        AND a.user_id = ?
        AND a.shift_date BETWEEN ? AND ?
    GROUP BY c.id, c.type, c.color
");
$stmt2->bind_param('iss', $user_id, $startDate, $endDate);
$stmt2->execute();
$result2 = $stmt2->get_result();

$leave_types = [];
while ($row = $result2->fetch_assoc()) {
    $leave_types[] = [
        'type' => $row['type'],
        'count' => (int)$row['count'],
        'color' => $row['color']
    ];
}

// ---------------------
// Return JSON Response
// ---------------------
echo json_encode([
    'present_days' => $present_days,
    'absent_days' => $absent_days,
    'total_days' => $total_days,
    'leave_types' => $leave_types
]);
?>
