<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

include("csism_db.php"); // your database connection file

// Get user_id from GET parameter
$user_id = isset($_GET['user_id']) ? $_GET['user_id'] : '';

try {
    if (empty($user_id)) {
        throw new Exception("Invalid user_id");
    }

    $stmt = $conn->prepare("SELECT noti_id, noti_title, noti_message, noti_type, Is_read, create_datetime FROM Notification WHERE staff_id = ? and status = 1 ORDER BY create_datetime DESC");
    $stmt->bind_param("s", $user_id); // bind as string
    $stmt->execute();
    $result = $stmt->get_result();

    $notifications = [];
    while ($row = $result->fetch_assoc()) {
        $notifications[] = $row;
    }

    echo json_encode(['notifications' => $notifications], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);

    $stmt->close();
    $conn->close();
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>
