<?php
// get_timecard.php
error_reporting(E_ALL);
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

include("csism_db.php");

header("Content-Type: application/json");

// Get user_id from query string
$user_id = isset($_GET['user_id']) ? intval($_GET['user_id']) : 0;

if ($user_id <= 0) {
    echo json_encode(["error" => "Invalid user_id"]);
    exit;
}

// Function to fetch data from a table
function fetchTimecards($conn, $table, $user_id) {
    $sql = "SELECT id, user_id, shift_date, check_in_time, check_out_time, attendance_status 
            FROM $table WHERE user_id = ?";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();

    $timecards = [];
    while ($row = $result->fetch_assoc()) {
        $timecards[] = [
            "id"      => (int)$row["id"],
            "user_id" => (int)$row["user_id"],
            "date"    => $row["shift_date"],
            "timeIn"  => $row["check_in_time"],
            "timeOut" => $row["check_out_time"],
            "status"  => $row["attendance_status"],
            "source"  => $table // mark where the record came from
        ];
    }

    $stmt->close();
    return $timecards;
}

// Fetch from both tables
$attendanceData = fetchTimecards($conn, "attendance", $user_id);
$outdoorData    = fetchTimecards($conn, "outdoor_attendance", $user_id);

// Merge results
$timecards = array_merge($attendanceData, $outdoorData);

// Sort by date (descending)
usort($timecards, function($a, $b) {
    return strtotime($b["date"]) - strtotime($a["date"]);
});

// If no data, return not found
if (empty($timecards)) {
    echo json_encode(["message" => "not found"]);
} else {
    echo json_encode($timecards);
}

$conn->close();
?>
