<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include("csism_db.php");
date_default_timezone_set('Asia/Kolkata'); // Set to your timezone

// Get POST data
$input = file_get_contents("php://input");
$data = json_decode($input, true);

$userId = isset($data['userId']) ? $data['userId'] : '1';
$latitude = isset($data['latitude']) ? $data['latitude'] : '';
$longitude = isset($data['longitude']) ? $data['longitude'] : '';
$currentDate = date('Y-m-d H:i:s'); // corrected format from 'H:m:s' to 'H:i:s'
$dateee = date('Y-m-d');
$timeee = date('H:i:s');

// Validate data
if (empty($userId) || empty($latitude) || empty($longitude)) {
    echo json_encode(array("status" => "error", "message" => "Missing parameters"));
    exit();
}

$updateQuery = "UPDATE staff_master SET lat = ?, lon = ? WHERE staff_id = ?";
$stmt = $conn->prepare($updateQuery);
$stmt->bind_param("sss", $latitude, $longitude, $userId);

if ($stmt->execute()) {
    echo json_encode(array("status" => "success", "message" => "Location data updated successfully"));
        // Record exists, update the date
        $updateSql = "UPDATE staff_master SET active_time = '$currentDate' WHERE staff_id = '$userId' AND status='1'";
        
        if ($conn->query($updateSql) === TRUE) {
            echo json_encode(['message' => 'Staff Status updated successfully']);
        } else {
            echo json_encode(['error' => 'Error updating staff status: ' . $conn->error]);
            file_put_contents('error_log.txt', $conn->error . PHP_EOL, FILE_APPEND);
        }
} else {
    echo json_encode(array("status" => "error", "message" => "Failed to update location data"));
}

// Close the statement and connection
$stmt->close();
$conn->close();
?>
