<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json");
date_default_timezone_set("Asia/Kolkata");

include("csism_db.php"); // DB connection

$response = ["success" => false, "message" => "Unknown error"];

/**
 * Compute attendance status (same as attendance login)
 */
function getAttendanceStatus($shiftIn, $shiftOut, $graceMin, $checkIn = null, $checkOut = null) {
    $status = "Present";
    $statusTypeId = 1;

    $halfDayTime = date('Y-m-d H:i:s', strtotime("+4 hours", strtotime($shiftIn)));
    $allowedCheckIn = date('Y-m-d H:i:s', strtotime("+$graceMin minutes", strtotime($shiftIn)));

    $isLate = false;
    $isFirstHalfAbsent = false;
    $isSecondHalfEarly = false;
    $isFirstHalfPresentSecondHalfAbsent = false;
    $isSecondHalfAbsentDueToNoCheckout = false;

    if ($checkIn) {
        if (strtotime($checkIn) > strtotime($allowedCheckIn) && strtotime($checkIn) <= strtotime($halfDayTime)) {
            $isLate = true;
        }
        if (strtotime($checkIn) > strtotime($halfDayTime)) {
            $isFirstHalfAbsent = true;
        }
    }

    if ($checkOut) {
        if (strtotime($checkOut) < strtotime($shiftOut) && strtotime($checkOut) >= strtotime($halfDayTime)) {
            $isSecondHalfEarly = true;
        }
        if (strtotime($checkOut) < strtotime($halfDayTime)) {
            $isFirstHalfPresentSecondHalfAbsent = true;
        }
    } else {
        if (time() > strtotime($shiftOut) && $checkIn) {
            $isSecondHalfAbsentDueToNoCheckout = true;
        }
    }

    if (!$checkIn && !$checkOut) {
        $status = "Absent"; $statusTypeId = 2;
    }
    elseif ($isFirstHalfAbsent && $isSecondHalfEarly) {
        $status = "1st HalfAbsent + 2nd HalfEarly Going"; $statusTypeId = 1;
    }
    elseif ($isLate && $isSecondHalfEarly) {
        $status = "Late + 2nd HalfEarly Going"; $statusTypeId = 6;
    }
    elseif ($isLate) {
        $status = "Late"; $statusTypeId = 6;
    }
    elseif ($isSecondHalfEarly) {
        $status = "2nd HalfEarly Going"; $statusTypeId = 1;
    }
    elseif ($isFirstHalfAbsent) {
        $status = "1st HalfAbsent"; $statusTypeId = 2;
    }
    elseif ($isFirstHalfPresentSecondHalfAbsent) {
        $status = "1st HalfPresent, 2nd HalfAbsent"; $statusTypeId = 1;
    }
    elseif ($isSecondHalfAbsentDueToNoCheckout) {
        $status = "2nd HalfAbsent"; $statusTypeId = 1;
    }
    else {
        $status = "Present"; $statusTypeId = 1;
    }

    return [$status, $statusTypeId];
}

try {
    if (empty($_POST['user_code']) || empty($_POST['type'])) {
        echo json_encode(["success" => false, "message" => "Missing required parameters"]);
        exit;
    }

    $user_code = $_POST['user_code'];
    $remark    = $_POST['remark'] ?? '';
    $latitude  = $_POST['latitude'] ?? '';
    $longitude = $_POST['longitude'] ?? '';
    $address   = $_POST['address'] ?? '';
    $type      = strtoupper($_POST['type']); // IN / OUT
    $datetime  = date("Y-m-d H:i:s");
    $currentdate = date("Y-m-d");

    // Handle file upload
    $photoPath = null;
    if (isset($_FILES['photo']) && $_FILES['photo']['error'] === UPLOAD_ERR_OK) {
        $uploadsDir = "../uploads/outdoor_images/";
        $setDir = "uploads/outdoor_images/";
        
        if (!is_dir($uploadsDir)) {
            mkdir($uploadsDir, 0777, true);
        }
    
        $fileTmp  = $_FILES['photo']['tmp_name'];
        $fileExt  = pathinfo($_FILES['photo']['name'], PATHINFO_EXTENSION);
        $fileName = uniqid() . "_" . preg_replace('/\s+/', '_', $address) . '.' . $fileExt;
        $target   = $uploadsDir . $fileName;
    
        // Compress image
        if (in_array(strtolower($fileExt), ['jpg', 'jpeg', 'png'])) {
            if (strtolower($fileExt) === 'png') {
                $image = imagecreatefrompng($fileTmp);
                imagepng($image, $target, 6); // Medium compression
            } else {
                $image = imagecreatefromjpeg($fileTmp);
                imagejpeg($image, $target, 60); // 60% quality
            }
            imagedestroy($image);
            $photoPath = $setDir . $fileName;
        } else {
            // fallback if not JPEG/PNG
            if (move_uploaded_file($fileTmp, $target)) {
                $photoPath = $setDir . $fileName;
            }
        }
    } else {
         $response = ["success" => false, "message" => "File not uploaded"];
    }

    file_put_contents("debug_upload.txt", print_r($_FILES, true));
    file_put_contents("debug_post.txt", print_r($_POST, true));
    
    if ($type === "IN") {
        // Use last shift date if needed (for night shifts, optional)
        $shiftIn  = $currentdate . " 09:00:00";
        $shiftOut = $currentdate . " 18:00:00";
        $graceMin = 15; // or fetch per-user

        list($status, $statusId) = getAttendanceStatus($shiftIn, $shiftOut, $graceMin, $datetime, null);

        $stmt = $conn->prepare("
            INSERT INTO outdoor_attendance 
            (user_id, checkin_remark, checkin_lat, checkin_long, checkin_add, check_in_time, checkin_image, shift_date, attendance_status, status_type_id) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
        ");
        $stmt->bind_param("sssssssssi", 
            $user_code, 
            $remark, 
            $latitude, 
            $longitude, 
            $address, 
            $datetime, 
            $photoPath,
            $currentdate,
            $status,
            $statusId
        );
        if ($stmt->execute()) {
            $response = ["success" => true, "message" => "✅ Check IN marked successfully"];
        } else {
            $response = ["success" => false, "message" => "DB Error: " . $stmt->error];
        }
        $stmt->close();

    } elseif ($type === "OUT") {
        // Get last IN record without checkout
        $lastRow = $conn->query("SELECT id, check_in_time, shift_date 
                                 FROM outdoor_attendance 
                                 WHERE user_id='$user_code' AND (check_out_time='' OR check_out_time IS NULL) 
                                 ORDER BY id DESC LIMIT 1")->fetch_assoc();

        if ($lastRow && empty($lastRow['check_out_time'])) {
            $lastShiftDate = $lastRow['shift_date'];

            // Allow checkout even if it's the next day
            if ($lastShiftDate == $currentdate || date('Y-m-d', strtotime($lastShiftDate . ' +1 day')) == $currentdate) {
                // Use shift based on last shift date
                $shiftIn  = $lastShiftDate . " 09:00:00";
                $shiftOut = $lastShiftDate . " 18:00:00";
                $graceMin = 15;

                list($status, $statusId) = getAttendanceStatus($shiftIn, $shiftOut, $graceMin, $lastRow['check_in_time'], $datetime);

                $stmt = $conn->prepare("
                    UPDATE outdoor_attendance 
                    SET check_out_time = ?, checkout_image = ?, checkout_lat = ?, checkout_long = ?, 
                        checkout_remark = ?, checkout_add = ?, attendance_status = ?, status_type_id = ? 
                    WHERE id = ?
                ");
                $stmt->bind_param("sssssssii", 
                    $datetime, $photoPath, $latitude, $longitude, $remark, $address,
                    $status, $statusId, $lastRow['id']
                );

                if ($stmt->execute() && $stmt->affected_rows > 0) {
                    $response = ["success" => true, "message" => "✅ Check OUT marked successfully"];
                } else {
                    $response = ["success" => false, "message" => "⚠️ Failed to update checkout"];
                }
                $stmt->close();
            } else {
                $response = ["success" => false, "message" => "⚠️ No active IN record to checkout (night shift)."];
            }
        } else {
            $response = ["success" => false, "message" => "⚠️ No pending IN record found for this user"];
        }
    } else {
        $response = ["success" => false, "message" => "Invalid type (use IN or OUT)"];
    }

    $conn->close();

} catch (Exception $e) {
    $response = ["success" => false, "message" => "Exception: " . $e->getMessage()];
}

echo json_encode($response);
