<?php
include("csism_db.php");

$user_id = $_GET['user_id'] ?? 0;

// Helper to convert time difference
function getTimeDiff($start, $end) {
    if (!$start || !$end) return "0h 0m";
    $diff = strtotime($end) - strtotime($start);
    $hours = floor($diff / 3600);
    $minutes = floor(($diff % 3600) / 60);
    return "{$hours}h {$minutes}m";
}

// --- TODAY ---
$today = date("Y-m-d");
$sqlToday = "SELECT check_in_time, check_out_time 
             FROM attendance 
             WHERE user_id=? AND DATE(date)=? 
             ORDER BY time ASC";
$stmt = $conn->prepare($sqlToday);
$stmt->bind_param("is", $user_id, $today);
$stmt->execute();
$res = $stmt->get_result();
$rows = $res->fetch_all(MYSQLI_ASSOC);

$firstIn = $rows[0]['check_in_time'] ?? null;
$lastOut = $rows[count($rows)-1]['check_out_time'] ?? null;
$currentWork = getTimeDiff($firstIn, $lastOut);

// --- THIS WEEK ---
$monday = date("Y-m-d", strtotime("monday this week"));
$sqlWeek = "SELECT check_in_time, check_out_time, date
            FROM attendance
            WHERE user_id=? AND DATE(date) BETWEEN ? AND ?
            ORDER BY date ASC";
$stmt = $conn->prepare($sqlWeek);
$stmt->bind_param("iss", $user_id, $monday, $today);
$stmt->execute();
$res = $stmt->get_result();
$weekRows = $res->fetch_all(MYSQLI_ASSOC);

$totalSeconds = 0;
foreach ($weekRows as $r) {
    if ($r['check_in_time'] && $r['check_out_time']) {
        $totalSeconds += (strtotime($r['check_out_time']) - strtotime($r['check_in_time']));
    }
}
$weekHours = floor($totalSeconds / 3600);
$weekMinutes = floor(($totalSeconds % 3600) / 60);
$thisWeek = "{$weekHours}h {$weekMinutes}m";

// --- EFFICIENCY ---
$expectedHours = (count(array_unique(array_column($weekRows, 'date')))) * 8; // 8h/day
$efficiency = $expectedHours > 0 ? round(($weekHours / $expectedHours) * 100, 2) : 0;

echo json_encode([
  "success" => true,
  "currently" => $currentWork,
  "this_week" => $thisWeek,
  "efficiency" => $efficiency . "%"
]);
