<?php
include("csism_db.php");
error_reporting(E_ALL);
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

$user_id = isset($_GET['user_id']) ? intval($_GET['user_id']) : 0;
if ($user_id <= 0) {
    echo json_encode(['success' => false, 'message' => "Invalid user_id"]);
    exit;
}

date_default_timezone_set('Asia/Kolkata');
$today = date('Y-m-d');

// ✅ Function to calculate total working seconds
function calculateWorkingSeconds($rows) {
    $totalSeconds = 0;
    foreach ($rows as $row) {
        $inTime  = $row['check_in_time'] ? new DateTime($row['check_in_time']) : null;
        $outTime = $row['check_out_time'] ? new DateTime($row['check_out_time']) : null;

        if ($inTime && $outTime) {
            $totalSeconds += $outTime->getTimestamp() - $inTime->getTimestamp();
        } elseif ($inTime && !$outTime) {
            $now = new DateTime('now', new DateTimeZone('Asia/Kolkata'));
            $totalSeconds += $now->getTimestamp() - $inTime->getTimestamp();
        }
    }
    return $totalSeconds;
}

// ✅ Try to fetch attendance first
$stmt = $conn->prepare("
    SELECT check_in_time, check_out_time 
    FROM attendance 
    WHERE user_id = ? AND shift_date = ? 
    ORDER BY check_in_time ASC
");
$stmt->bind_param("is", $user_id, $today);
$stmt->execute();
$result = $stmt->get_result();

$attendanceRows = [];
while ($row = $result->fetch_assoc()) {
    $attendanceRows[] = $row;
}
$stmt->close();

// If no attendance, check outdoor_attendance
if (empty($attendanceRows)) {
    $stmt = $conn->prepare("
        SELECT check_in_time, check_out_time 
        FROM outdoor_attendance 
        WHERE user_id = ? AND shift_date = ? 
        ORDER BY check_in_time ASC
    ");
    $stmt->bind_param("is", $user_id, $today);
    $stmt->execute();
    $result = $stmt->get_result();

    while ($row = $result->fetch_assoc()) {
        $attendanceRows[] = $row;
    }
    $stmt->close();
}

if (empty($attendanceRows)) {
    echo json_encode([
        'success' => false,
        'message' => 'Attendance not found for today'
    ]);
    $conn->close();
    exit;
}

// ✅ Calculate first check-in, last check-out and total working hours
$firstCheckIn = null;
$lastCheckOut = null;

foreach ($attendanceRows as $row) {
    if (!$firstCheckIn) $firstCheckIn = $row['check_in_time'];
    if ($row['check_out_time']) $lastCheckOut = $row['check_out_time'];
}

$totalSeconds = calculateWorkingSeconds($attendanceRows);

$hours   = floor($totalSeconds / 3600);
$minutes = floor(($totalSeconds % 3600) / 60);
$seconds = $totalSeconds % 60;

$workingHours = [
    "hours" => $hours,
    "minutes" => $minutes,
    "seconds" => $seconds,
    "formatted" => sprintf("%02d:%02d:%02d", $hours, $minutes, $seconds)
];

// ✅ Response
echo json_encode([
    'success' => true,
    'date' => $today,
    'check_in_time' => $firstCheckIn,
    'check_out_time' => $lastCheckOut,
    'working_hours' => $workingHours
]);

$conn->close();
?>
