<?php
include("csism_db.php");

header("Content-Type: application/json");

$user_id = $_GET['user_id'] ?? 0;

// 1️⃣ Weekly total time
$sql = "
    SELECT 
        SUM(TIMESTAMPDIFF(SECOND, check_in_time, check_out_time)) AS total_seconds
    FROM attendance
    WHERE user_id = ?
      AND YEARWEEK(shift_date, 1) = YEARWEEK(CURDATE(), 1)
";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result()->fetch_assoc();

$total_seconds = intval($result['total_seconds'] ?? 0);

// Convert seconds → h m
$hours   = floor($total_seconds / 3600);
$minutes = floor(($total_seconds % 3600) / 60);

$formatted = $hours . "h " . $minutes . "m";

// 2️⃣ Monthly Attendance %

// Count total days (present + absent)
$sql_total_days = "
    SELECT COUNT(DISTINCT shift_date) AS total_days
    FROM attendance
    WHERE user_id = ?
      AND MONTH(shift_date) = MONTH(CURDATE())
      AND YEAR(shift_date) = YEAR(CURDATE())
";

$stmt2 = $conn->prepare($sql_total_days);
$stmt2->bind_param("i", $user_id);
$stmt2->execute();
$result_total = $stmt2->get_result()->fetch_assoc();
$total_days = intval($result_total['total_days'] ?? 0);

// Count present days
$sql_present_days = "
    SELECT COUNT(DISTINCT shift_date) AS present_days
    FROM attendance
    WHERE user_id = ?
      AND MONTH(shift_date) = MONTH(CURDATE())
      AND YEAR(shift_date) = YEAR(CURDATE())
      AND status_type_id = '1' OR status_type_id = '3'
";

$stmt3 = $conn->prepare($sql_present_days);
$stmt3->bind_param("i", $user_id);
$stmt3->execute();
$result_present = $stmt3->get_result()->fetch_assoc();
$present_days = intval($result_present['present_days'] ?? 0);

// Calculate %
$attendance_percent = $total_days > 0 ? round(($present_days / $total_days) * 100, 2) : 0;

echo json_encode([
    "status" => "success",
    "total_week_time" => $formatted,
    "raw_seconds" => $total_seconds,
    "month_attendance_percent" => $attendance_percent,
    "present_days" => $present_days,
    "total_days" => $total_days
]);


?>