<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
include("csism_db.php"); // ðŸ”¹ your DB connection file

date_default_timezone_set('Asia/Kolkata');

// âœ… Get userId from query param
$userId = isset($_GET['userId']) ? intval($_GET['userId']) : 0;
if ($userId <= 0) {
    echo json_encode([
        "success" => false,
        "message" => "Invalid userId"
    ]);
    exit;
}

$today = date("Y-m-d");

// âœ… Fetch today's attendance record for this user
$sql = "SELECT check_in_time , check_out_time FROM outdoor_attendance 
        WHERE user_id = ? AND shift_date = ? ORDER BY id DESC limit 1";
$stmt = $conn->prepare($sql);
$stmt->bind_param("is", $userId, $today);
$stmt->execute();
$result = $stmt->get_result();

$response = [
    "success" => true,
    "hasCheckIn" => false,
    "hasCheckOut" => false,
    "message" => "No record yet"
];

if ($row = $result->fetch_assoc()) {
    if (!empty($row['check_in_time'])) {
        $response["hasCheckIn"] = true;
        $response["message"] = "User already checked in";
    }
    if (!empty($row['check_out_time'])) {
        $response["hasCheckOut"] = true;
        $response["message"] = "User already checked out";
    }
}

echo json_encode($response);
?>
