<?php
include("csism_db.php"); // your DB connection file

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

// Check if userid is provided
if (!isset($_POST['userid']) || empty($_POST['userid'])) {
    echo json_encode([
        "success" => false,
        "message" => "User ID is required"
    ]);
    exit;
}

$userid = intval($_POST['userid']); // sanitize input

try {
    // Prepare query
    $stmt = $conn->prepare("SELECT name, number, username, email, gender, address, city, pin_code, state FROM staff_master
                            WHERE staff_id = ?");
    $stmt->bind_param("i", $userid);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        
        echo json_encode([
            "success" => true,
            "name" => $row['name'],
            "phone" => $row['number'],
            "email" => $row['email'],
            "gender" => $row['gender'],
            "address" => $row['address'],
            "city" => $row['city'],
            "pincode" => $row['pin_code'],
            "state" => $row['state'],
            "username" => $row['username'],
        ]);
    } else {
        echo json_encode([
            "success" => false,
            "message" => "No user found"
        ]);
    }

    $stmt->close();
    $conn->close();
} catch (Exception $e) {
    echo json_encode([
        "success" => false,
        "message" => "Error: " . $e->getMessage()
    ]);
}
