<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
include("CSismApk/csism_db.php"); // DB connection
// Fetch visitor entries
$sql = "SELECT `id`, `name`, `phone`, `purpose`, `description`, `photo_url`, 
        `latitude`, `longitude`, `entry_timestamp`, `created_at`, `updated_at`, `status` 
        FROM `visitor_entries` WHERE 1";

$result = mysqli_query($conn, $sql);
$visitors = [];

if ($result) {
    while ($row = mysqli_fetch_assoc($result)) {
        $visitors[] = $row;
    }
}

mysqli_close($conn);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Visitor Entries - Admin Panel</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }

        .container {
            max-width: 1400px;
            margin: 0 auto;
        }

        .header {
            background: white;
            padding: 25px;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.2);
            margin-bottom: 30px;
        }

        .header h1 {
            color: #667eea;
            font-size: 32px;
            margin-bottom: 5px;
        }

        .header p {
            color: #666;
            font-size: 14px;
        }

        .stats {
            display: flex;
            gap: 20px;
            margin-bottom: 30px;
            flex-wrap: wrap;
        }

        .stat-card {
            background: white;
            padding: 20px;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            flex: 1;
            min-width: 200px;
        }

        .stat-card h3 {
            color: #666;
            font-size: 14px;
            margin-bottom: 10px;
        }

        .stat-card .number {
            font-size: 32px;
            font-weight: bold;
            color: #667eea;
        }

        .table-container {
            background: white;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.2);
            overflow: hidden;
        }

        .table-header {
            padding: 20px 25px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }

        .table-header h2 {
            font-size: 24px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        thead {
            background: #f8f9fa;
        }

        th {
            padding: 15px;
            text-align: left;
            font-weight: 600;
            color: #333;
            border-bottom: 2px solid #e0e0e0;
            font-size: 14px;
        }

        td {
            padding: 15px;
            border-bottom: 1px solid #f0f0f0;
            color: #555;
            font-size: 14px;
        }

        tbody tr {
            transition: all 0.3s ease;
        }

        tbody tr:hover {
            background: #f8f9ff;
            transform: scale(1.01);
        }

        .photo {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            object-fit: cover;
            border: 3px solid #667eea;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .photo:hover {
            transform: scale(1.1);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        }

        .status-badge {
            padding: 5px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
            text-transform: uppercase;
        }

        .status-active {
            background: #d4edda;
            color: #155724;
        }

        .status-inactive {
            background: #f8d7da;
            color: #721c24;
        }

        .status-pending {
            background: #fff3cd;
            color: #856404;
        }

        .btn-map {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            padding: 8px 16px;
            border-radius: 8px;
            cursor: pointer;
            font-size: 13px;
            transition: all 0.3s ease;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }

        .btn-map:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        }

        .btn-map:disabled {
            background: #ccc;
            cursor: not-allowed;
            transform: none;
        }

        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.7);
            z-index: 1000;
            justify-content: center;
            align-items: center;
        }

        .modal.active {
            display: flex;
        }

        .modal-content {
            background: white;
            border-radius: 15px;
            width: 90%;
            max-width: 900px;
            max-height: 90vh;
            overflow-y: auto;
            overflow-x: hidden;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
        }

        .modal-content::-webkit-scrollbar {
            width: 8px;
        }

        .modal-content::-webkit-scrollbar-track {
            background: #f1f1f1;
            border-radius: 10px;
        }

        .modal-content::-webkit-scrollbar-thumb {
            background: #667eea;
            border-radius: 10px;
        }

        .modal-content::-webkit-scrollbar-thumb:hover {
            background: #764ba2;
        }

        .modal-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 20px 25px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: sticky;
            top: 0;
            z-index: 10;
        }

        .modal-header h3 {
            font-size: 22px;
        }

        .close-btn {
            background: rgba(255,255,255,0.2);
            border: none;
            color: white;
            width: 35px;
            height: 35px;
            border-radius: 50%;
            cursor: pointer;
            font-size: 20px;
            transition: all 0.3s ease;
        }

        .close-btn:hover {
            background: rgba(255,255,255,0.3);
            transform: rotate(90deg);
        }

        .modal-body {
            padding: 25px;
        }

        #map {
            width: 100%;
            height: 500px;
            border-radius: 10px;
            border: 2px solid #e0e0e0;
        }

        .photo-modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.9);
            z-index: 2000;
            justify-content: center;
            align-items: center;
        }

        .photo-modal.active {
            display: flex;
        }

        .photo-modal-content {
            max-width: 90%;
            max-height: 90vh;
            position: relative;
        }

        .photo-modal-content img {
            max-width: 100%;
            max-height: 90vh;
            width: auto;
            height: auto;
            border-radius: 10px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.5);
            object-fit: contain;
        }

        /* Handle image orientation */
        .photo-modal-content img.portrait {
            max-width: 60vh;
        }

        .photo-modal-content img.landscape {
            max-width: 90%;
        }

        .photo-close-btn {
            position: absolute;
            top: -40px;
            right: 0;
            background: rgba(255,255,255,0.2);
            border: none;
            color: white;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            cursor: pointer;
            font-size: 24px;
            transition: all 0.3s ease;
        }

        .photo-close-btn:hover {
            background: rgba(255,255,255,0.3);
            transform: rotate(90deg);
        }

        .photo-info {
            position: absolute;
            bottom: -60px;
            left: 0;
            right: 0;
            text-align: center;
            color: white;
            font-size: 18px;
            font-weight: 500;
        }

        .no-data {
            text-align: center;
            padding: 40px;
            color: #999;
        }

        .visitor-info {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 10px;
            margin-bottom: 15px;
        }

        .visitor-info p {
            margin: 8px 0;
            color: #555;
        }

        .visitor-info strong {
            color: #333;
        }

        @media (max-width: 768px) {
            .table-container {
                overflow-x: auto;
            }

            table {
                min-width: 800px;
            }

            .stats {
                flex-direction: column;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1><i class="fas fa-users"></i> Visitor Management System</h1>
            <p>Admin Dashboard - Manage and track all visitor entries</p>
        </div>

        <div class="stats">
            <div class="stat-card">
                <h3>Total Visitors</h3>
                <div class="number"><?php echo count($visitors); ?></div>
            </div>
            <div class="stat-card">
                <h3>Active</h3>
                <div class="number">
                    <?php echo count(array_filter($visitors, fn($v) => strtolower($v['status']) === 'active')); ?>
                </div>
            </div>
            <div class="stat-card">
                <h3>With Location</h3>
                <div class="number">
                    <?php echo count(array_filter($visitors, fn($v) => !empty($v['latitude']) && !empty($v['longitude']))); ?>
                </div>
            </div>
        </div>

        <div class="table-container">
            <div class="table-header">
                <h2><i class="fas fa-list"></i> Visitor Entries</h2>
            </div>
            
            <?php if (count($visitors) > 0): ?>
            <table>
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Photo</th>
                        <th>Name</th>
                        <th>Phone</th>
                        <th>Purpose</th>
                        <th>Description</th>
                        <th>Entry Time</th>
                        <th>Status</th>
                        <th>Location</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($visitors as $visitor): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($visitor['id']); ?></td>
                        <td>
                            <?php if (!empty($visitor['photo_url'])): ?>
                                <img src="<?php echo htmlspecialchars($visitor['photo_url']); ?>" 
                                     alt="Visitor Photo" 
                                     class="photo"
                                     style="object-fit: cover;"
                                     onclick='showPhoto("<?php echo addslashes(htmlspecialchars($visitor['photo_url'])); ?>", "<?php echo addslashes(htmlspecialchars($visitor['name'])); ?>")'>
                            <?php else: ?>
                                <div class="photo" style="background: #667eea; display: flex; align-items: center; justify-content: center; color: white; font-weight: bold;">
                                    <?php echo strtoupper(substr($visitor['name'], 0, 1)); ?>
                                </div>
                            <?php endif; ?>
                        </td>
                        <td><strong><?php echo htmlspecialchars($visitor['name']); ?></strong></td>
                        <td><?php echo htmlspecialchars($visitor['phone']); ?></td>
                        <td><?php echo htmlspecialchars($visitor['purpose']); ?></td>
                        <td><?php echo htmlspecialchars(substr($visitor['description'], 0, 50)) . (strlen($visitor['description']) > 50 ? '...' : ''); ?></td>
                        <td><?php echo date('M d, Y H:i', strtotime($visitor['entry_timestamp'])); ?></td>
                        <td>
                            <span class="status-badge status-<?php echo strtolower($visitor['status']); ?>">
                                <?php echo htmlspecialchars($visitor['status']); ?>
                            </span>
                        </td>
                        <td>
                            <?php if (!empty($visitor['latitude']) && !empty($visitor['longitude'])): ?>
                                <button class="btn-map" onclick='showMap(<?php echo json_encode($visitor); ?>)'>
                                    <i class="fas fa-map-marker-alt"></i> Show Map
                                </button>
                            <?php else: ?>
                                <button class="btn-map" disabled>
                                    <i class="fas fa-map-marker-alt"></i> No Location
                                </button>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <?php else: ?>
                <div class="no-data">
                    <i class="fas fa-inbox" style="font-size: 48px; color: #ccc; margin-bottom: 15px;"></i>
                    <p>No visitor entries found</p>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Modal for Map -->
    <div class="modal" id="mapModal">
        <div class="modal-content">
            <div class="modal-header">
                <h3><i class="fas fa-map-marked-alt"></i> Visitor Location</h3>
                <button class="close-btn" onclick="closeMap()">×</button>
            </div>
            <div class="modal-body">
                <div class="visitor-info" id="visitorInfo"></div>
                <div id="map"></div>
            </div>
        </div>
    </div>

    <!-- Modal for Photo -->
    <div class="photo-modal" id="photoModal">
        <div class="photo-modal-content">
            <button class="photo-close-btn" onclick="closePhoto()">×</button>
            <img id="photoImage" src="" alt="Visitor Photo">
            <div class="photo-info" id="photoInfo"></div>
        </div>
    </div>

    <!-- Leaflet CSS and JS for Map -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/leaflet/1.9.4/leaflet.css" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/leaflet/1.9.4/leaflet.js"></script>

    <script>
        let map = null;
        let marker = null;

        function showPhoto(photoUrl, visitorName) {
            const modal = document.getElementById('photoModal');
            const photoImage = document.getElementById('photoImage');
            const photoInfo = document.getElementById('photoInfo');
            
            photoImage.src = photoUrl;
            photoInfo.textContent = visitorName;
            
            // Detect image orientation after loading
            photoImage.onload = function() {
                if (this.naturalHeight > this.naturalWidth) {
                    // Portrait/Vertical image
                    this.classList.add('portrait');
                    this.classList.remove('landscape');
                } else {
                    // Landscape/Horizontal image
                    this.classList.add('landscape');
                    this.classList.remove('portrait');
                }
            };
            
            modal.classList.add('active');
        }

        function closePhoto() {
            const modal = document.getElementById('photoModal');
            modal.classList.remove('active');
        }

        function showMap(visitor) {
            const modal = document.getElementById('mapModal');
            const visitorInfo = document.getElementById('visitorInfo');
            
            // Display visitor information
            visitorInfo.innerHTML = `
                <p><strong>Name:</strong> ${visitor.name}</p>
                <p><strong>Phone:</strong> ${visitor.phone}</p>
                <p><strong>Purpose:</strong> ${visitor.purpose}</p>
                <p><strong>Entry Time:</strong> ${new Date(visitor.entry_timestamp).toLocaleString()}</p>
                <p><strong>Coordinates:</strong> ${visitor.latitude}, ${visitor.longitude}</p>
            `;
            
            modal.classList.add('active');
            
            // Initialize map
            setTimeout(() => {
                if (map) {
                    map.remove();
                }
                
                map = L.map('map').setView([visitor.latitude, visitor.longitude], 15);
                
                L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                    attribution: '© OpenStreetMap contributors',
                    maxZoom: 19
                }).addTo(map);
                
                marker = L.marker([visitor.latitude, visitor.longitude])
                    .addTo(map)
                    .bindPopup(`
                        <div style="text-align: center;">
                            <strong>${visitor.name}</strong><br>
                            ${visitor.purpose}<br>
                            <small>${new Date(visitor.entry_timestamp).toLocaleString()}</small>
                        </div>
                    `)
                    .openPopup();
                
                // Add circle around the marker
                L.circle([visitor.latitude, visitor.longitude], {
                    color: '#667eea',
                    fillColor: '#667eea',
                    fillOpacity: 0.2,
                    radius: 100
                }).addTo(map);
                
            }, 100);
        }

        function closeMap() {
            const modal = document.getElementById('mapModal');
            modal.classList.remove('active');
            if (map) {
                map.remove();
                map = null;
            }
        }

        // Close photo modal when clicking outside
        document.getElementById('photoModal').addEventListener('click', function(e) {
            if (e.target === this) {
                closePhoto();
            }
        });

        // Close map modal when clicking outside
        document.getElementById('mapModal').addEventListener('click', function(e) {
            if (e.target === this) {
                closeMap();
            }
        });
    </script>
</body>
</html>